#ifndef MUSIC_H
#define MUSIC_H

#include <AL/al.h>
#include <AL/alc.h>
#include <ogg/vorbisfile.h>

#include <pthread/pthread.h>

class CMusic
{
    friend void *threadMusic(void *data);
    friend void *threadMusicList(void *data);
    
    private:
        // Variables associes au fichier ogg-vorbis  lire
        OggVorbis_File Stream;
        FILE*          File       ;
        ALenum         Format     ;
        ALsizei        SampleRate ;
        
        char *fileName;//nom du fichier en cours de lecture
        unsigned short int nbMusic,id;//info sur la listes des fichiers en cours de lecture
        //id c'est le numro du fichier en cours
        char **listFileName;//tableau des fichiers  lire
        bool loopM;//si on boucle la liste
        
        bool okThread;//Si les threads sont autoriss  rester en vie
        pthread_t musicThrd;//thread de lecture de musique
        ALuint srcM;//rfrence du morceau qui se jou
        bool pauze;//pause de la musique
        
        float volume;//volume global
        
    private:
        //voir tutoriel sur les ogg : http://loulou.developpez.com/tutoriels/openal/flux-ogg/
        bool OpenOgg(char *fineName);
        bool ReadOgg(ALuint Buffer, ALsizei NbSamples);
        void CloseOgg();
        
    public:
        CMusic();
        ~CMusic();
        
        void setVolume(float volume);
        
        void launchMusic(char *fileName);
        void launchMusicList(unsigned short int nbMusic,char **listFileName,bool loopM=true);
        void launchMusicListID(unsigned short int nbMusic,char **listFileName,unsigned char id,bool loopM=true);
        void stopMusic();
        void play();
        void pause();
        
        static bool InitOpenAL(const char* DeviceName = NULL);
        static void ShutdownOpenAL();
        
        unsigned char setId(unsigned char id);
        unsigned char getId();
};

void *threadMusic(void *data);//fonction de lecture d'une musique
void *threadMusicList(void *data);//fonction de lecture d'une liste de musique

#endif
